/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.Face;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.entity.EntitySlashEffect;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SlashEffectRenderer<T extends EntitySlashEffect>
extends EntityRenderer<T> {
    private static final ResourceLocation modelLocation = new ResourceLocation("slashblade", "model/util/slash.obj");
    private static final ResourceLocation textureLocation = new ResourceLocation("slashblade", "model/util/slash.png");

    @Nullable
    public ResourceLocation getTextureLocation(T entity) {
        return textureLocation;
    }

    public SlashEffectRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStackIn);){
            float windscale;
            MSAutoCloser msacb;
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-Mth.m_14179_((float)partialTicks, (float)((EntitySlashEffect)entity).f_19859_, (float)entity.m_146908_()) - 90.0f));
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14179_((float)partialTicks, (float)((EntitySlashEffect)entity).f_19860_, (float)entity.m_146909_())));
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(((EntitySlashEffect)entity).getRotationRoll()));
            WavefrontObject model = BladeModelManager.getInstance().getModel(modelLocation);
            int lifetime = ((EntitySlashEffect)entity).getLifetime();
            float progress = Math.min((float)lifetime, (float)((EntitySlashEffect)entity).f_19797_ + partialTicks) / (float)lifetime;
            double deathTime = lifetime;
            double baseAlpha = Math.min(deathTime, (double)Math.max(0.0f, (float)(lifetime - ((EntitySlashEffect)entity).f_19797_) - partialTicks)) / deathTime;
            baseAlpha = -Math.pow(baseAlpha - 1.0, 4.0) + 1.0;
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(((EntitySlashEffect)entity).getRotationOffset() - 135.0f * progress));
            matrixStackIn.m_85841_(1.0f, 0.25f, 1.0f);
            float baseScale = 1.2f;
            matrixStackIn.m_85841_(baseScale, baseScale, baseScale);
            float yscale = 0.03f;
            float scale = ((EntitySlashEffect)entity).getBaseSize() * Mth.m_14179_((float)progress, (float)0.03f, (float)0.035f);
            int color = ((EntitySlashEffect)entity).getColor() & 0xFFFFFF;
            IConcentrationRank.ConcentrationRanks rank = ((EntitySlashEffect)entity).getRankCode();
            if (rank.level < IConcentrationRank.ConcentrationRanks.C.level) {
                color = 0x555555;
            }
            ResourceLocation rl = this.getTextureLocation(entity);
            int alpha = (0xFF & (int)(255.0 * baseAlpha)) << 24;
            if (IConcentrationRank.ConcentrationRanks.S.level <= rank.level) {
                msacb = MSAutoCloser.pushMatrix(matrixStackIn);
                try {
                    windscale = ((EntitySlashEffect)entity).getBaseSize() * Mth.m_14179_((float)progress, (float)0.035f, (float)0.03f);
                    matrixStackIn.m_85841_(windscale, yscale, windscale);
                    Face.setAlphaOverride(Face.alphaOverrideYZZ);
                    Face.setUvOperator(1.0f, 1.0f, 0.0f, -0.8f + progress * 0.3f);
                    BladeRenderState.setCol(0x222222 | alpha);
                    BladeRenderState.renderOverridedColorWrite(ItemStack.f_41583_, model, "base", rl, matrixStackIn, bufferIn, packedLightIn);
                }
                finally {
                    if (msacb != null) {
                        msacb.close();
                    }
                }
            }
            if (IConcentrationRank.ConcentrationRanks.D.level <= rank.level) {
                msacb = MSAutoCloser.pushMatrix(matrixStackIn);
                try {
                    matrixStackIn.m_85841_(scale, yscale, scale);
                    Face.setAlphaOverride(Face.alphaOverrideYZZ);
                    Face.setUvOperator(1.0f, 1.0f, 0.0f, -0.35f + progress * -0.15f);
                    BladeRenderState.setCol(color | alpha);
                    BladeRenderState.renderOverridedColorWrite(ItemStack.f_41583_, model, "base", rl, matrixStackIn, bufferIn, packedLightIn);
                }
                finally {
                    if (msacb != null) {
                        msacb.close();
                    }
                }
            }
            if (IConcentrationRank.ConcentrationRanks.B.level <= rank.level) {
                msacb = MSAutoCloser.pushMatrix(matrixStackIn);
                try {
                    windscale = ((EntitySlashEffect)entity).getBaseSize() * Mth.m_14179_((float)progress, (float)0.03f, (float)0.0375f);
                    matrixStackIn.m_85841_(windscale, yscale, windscale);
                    Face.setAlphaOverride(Face.alphaOverrideYZZ);
                    Face.setUvOperator(1.0f, 1.0f, 0.0f, -0.5f + progress * -0.2f);
                    BladeRenderState.setCol(0x404040 | alpha);
                    BladeRenderState.renderOverridedLuminous(ItemStack.f_41583_, model, "base", rl, matrixStackIn, bufferIn, packedLightIn);
                }
                finally {
                    if (msacb != null) {
                        msacb.close();
                    }
                }
            }
            msacb = MSAutoCloser.pushMatrix(matrixStackIn);
            try {
                matrixStackIn.m_85841_(scale, yscale, scale);
                Face.setAlphaOverride(Face.alphaOverrideYZZ);
                Face.setUvOperator(1.0f, 1.0f, 0.0f, -0.35f + progress * -0.15f);
                BladeRenderState.setCol(color | alpha);
                BladeRenderState.renderOverridedLuminous(ItemStack.f_41583_, model, "base", rl, matrixStackIn, bufferIn, packedLightIn);
            }
            finally {
                if (msacb != null) {
                    msacb.close();
                }
            }
        }
    }
}

